#include "bdtypes.h"
#include "bdfunc.h"
#include "bdglobal.h"

#define SCREEN_X	640
#define SCREEN_Y	480

#ifndef max
#define max(a,b) (((a)>(b))?(a):(b))
#endif

#ifndef min
#define min(a,b) (((a)<(b))?(a):(b))
#endif
extern char *PackageName;

FxU32 GiveFxU32(int Nb)
{
	switch(Nb)
	{
	case 256:
		return GR_LOD_256;
	case 128:
		return GR_LOD_128;
	case 64:
		return GR_LOD_64;
	case 32:
		return GR_LOD_32;
	case 16:
		return GR_LOD_16;
	case 8:
		return GR_LOD_8;
	case 4:
		return GR_LOD_4;
	case 2:
		return GR_LOD_2;
	default:
		return GR_LOD_1;
	}
}

/********************************************/
/* Loads a texture and returns a handle		*/
/* to it									*/
/********************************************/

GrMipMapId_t LoadTexture(char *filename)
{
	Gu3dfInfo fileInfo;
	GrMipMapId_t mipmapid;

	// Can I get infos ?
	if (gu3dfGetInfo(filename,&fileInfo)==FXFALSE)
	{
		return -1;
	}
	if ((fileInfo.data = malloc(fileInfo.mem_required))==NULL)
	{
		return -1;
	}
	if (gu3dfLoad(filename,&fileInfo)==FXFALSE)
	{
		return -1;
	}

	// Allocate texture memory	on 3Dfx
	mipmapid=guTexAllocateMemory(
	GR_TMU0,
	GR_MIPMAPLEVELMASK_BOTH,
	fileInfo.header.width,fileInfo.header.height,
	fileInfo.header.format,
	GR_MIPMAP_NEAREST,
	fileInfo.header.small_lod,fileInfo.header.large_lod,
	fileInfo.header.aspect_ratio,
	GR_TEXTURECLAMP_WRAP,GR_TEXTURECLAMP_WRAP,
	GR_TEXTUREFILTER_BILINEAR,GR_TEXTUREFILTER_BILINEAR,
	0.0f,FXFALSE);

	if (mipmapid==GR_NULL_MIPMAP_HANDLE)
	{
		return -1;
	}

	// Upload the texture to the video card
	guTexDownloadMipMap(mipmapid,fileInfo.data,&fileInfo.table.nccTable);

	free(fileInfo.data); // Free temp memory

	return mipmapid; // Return handle
}


/********************************************/
/* Save screen into a bitmap file			*/
/********************************************/

#ifdef WIN32
void Save_Screen(void)
{
	BITMAPFILEHEADER	bfHdr;
	BITMAPINFO			bmi;
	HANDLE            hFile;
	DWORD bytes;
	GrLfbInfo_t info;
	int x,y;
	unsigned short *bufferpointer=NULL,*temppointer=NULL,*ptr=NULL,*tptr=NULL;
	char FileName[20];
	static int Nb=0;

	// Allocate temp memory
	temppointer=(unsigned short *)malloc((SCREEN_X*SCREEN_Y)*2);

	// Lock
	info.size=sizeof(GrLfbInfo_t);
	while (grLfbLock(GR_LFB_READ_ONLY,GR_BUFFER_FRONTBUFFER, 
		GR_LFBWRITEMODE_ANY,GR_ORIGIN_UPPER_LEFT,FXFALSE,&info)==FXFALSE);
	
	bufferpointer = (unsigned short*) info.lfbPtr;

	for (y=0; y!=SCREEN_Y; y++)
		{
		ptr=bufferpointer+(y*(info.strideInBytes>>1));
		tptr=temppointer+(y*SCREEN_X);
		for (x=0; x!=SCREEN_X; x++)
			{
			(*tptr)=(*ptr);
			tptr++;
			ptr++;
			}
		}

	// Unlock
	grLfbUnlock(GR_LFB_READ_ONLY,GR_BUFFER_FRONTBUFFER);

	// Convert pixel format
	for (x=0; x!=(SCREEN_X*SCREEN_Y); x++)
		{
		__asm
			{
			push eax
			push edi

			mov edi,temppointer
			add edi,x
			add edi,x

			xor eax,eax

			mov ax,[edi]	// 0|0|rrrrrggg|gggbbbbb
			shl eax,2		//	0|000000rr|rrrggggg|gbbbbb00
			shl al,1			//	0|000000rr|rrrggggg|bbbbb000
			shr eax,3		// 0|0|0rrrrrgg|gggbbbbb
			mov [edi],ax

			pop edi
			pop eax
			}
		}

	// Clear structure
	memset(&bmi,0,sizeof(BITMAPINFO));

	// Set up the BitMap Header
	bmi.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
	bmi.bmiHeader.biWidth=SCREEN_X;
	bmi.bmiHeader.biHeight=SCREEN_Y;
	bmi.bmiHeader.biPlanes=1;
	bmi.bmiHeader.biBitCount=16;
	bmi.bmiHeader.biCompression=BI_RGB;
	bmi.bmiHeader.biSizeImage=0;

	// Set up the BitMap File Header
	bfHdr.bfType=('B'+('M'<<8));
	bfHdr.bfSize=sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFO)+((SCREEN_X*SCREEN_Y)*2);
	bfHdr.bfReserved1=0;
	bfHdr.bfReserved2=0;
	bfHdr.bfOffBits=sizeof(BITMAPINFO)+sizeof(BITMAPFILEHEADER);

	// Open file

	sprintf(FileName, "dump%d.bmp", Nb++);
	hFile=CreateFile(FileName,GENERIC_WRITE,FILE_SHARE_READ,
						  NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE,NULL);

	// Save header
	WriteFile(hFile,&bfHdr,sizeof(BITMAPFILEHEADER),&bytes,NULL); 

	// Save BitmapInfo
	WriteFile(hFile,&bmi,sizeof(BITMAPINFO),&bytes,NULL);

	// Save Bitmap
	WriteFile(hFile,temppointer,(SCREEN_X*SCREEN_Y)*2,&bytes,NULL);

	CloseHandle(hFile); // Close file
	
	free(temppointer); // Free temp memory
	}
#endif

/********************************************/
/* Loads a texture from a JPEG				*/
/* and returns a handle	to it				*/
/********************************************/

int LoadJpegTexture(DWORD filename, JpegTexture* tex)
{
	WORD *buffer;
	int width, height;

	buffer = LoadJpeg2Array(filename, &width, &height);

	tex->start = g_StartTextMem;
	g_StartTextMem += width * height * 2;

	if (width == 256)
	{
		tex->info.smallLod = GR_LOD_256;
		tex->info.largeLod = GR_LOD_256;
	}
	else
	{
		tex->info.smallLod = GR_LOD_128;
		tex->info.largeLod = GR_LOD_128;
	}
	tex->info.aspectRatio = GR_ASPECT_1x1;
	tex->info.format = GR_TEXFMT_RGB_565;
	tex->info.data = buffer;

	tex->tmu = GR_TMU0;
	tex->evenOdd= GR_MIPMAPLEVELMASK_BOTH;

	grTexDownloadMipMap(tex->tmu, tex->start, tex->evenOdd, &tex->info);
	free(buffer);

	return true;
}

/********************************************/
/* Loads a texture from a JPEG				*/
/* and returns a handle	to it				*/
/********************************************/

int LoadTextureFromArray(WORD *pArray, int width, int height, JpegTexture* tex)
{
	tex->start = g_StartTextMem;
	g_StartTextMem += width * height * 2;

	PrepareTextureFromArray(pArray, width, height, tex);

	grTexDownloadMipMap(tex->tmu, tex->start, tex->evenOdd, &tex->info);

	return true;
}


/********************************************/
/* PrepareTextureFromArray					*/
/* Fill a JpegTexture structure				*/
/********************************************/
int PrepareTextureFromArray(WORD *pArray, int width, int height, JpegTexture* tex)
{
	int Ratio;

	Ratio = max(width, height) / min(width, height);
	switch(Ratio)
	{
	case 1:
		tex->info.aspectRatio = GR_ASPECT_1x1;
		break;
	case 2:
		tex->info.aspectRatio = (width>height)?GR_ASPECT_2x1:GR_ASPECT_1x2;
		break;
	case 4:
		tex->info.aspectRatio = (width>height)?GR_ASPECT_4x1:GR_ASPECT_1x4;
		break;
	case 8:
		tex->info.aspectRatio = (width>height)?GR_ASPECT_8x1:GR_ASPECT_1x8;
		break;
	}

	tex->width = width;
	tex->height = height;

	tex->info.largeLod = GiveFxU32(max(width, height));
	//tex->info.smallLod = GiveFxU32(min(width, height));
	tex->info.smallLod = tex->info.largeLod;

	tex->info.format = GR_TEXFMT_RGB_565;
	tex->info.data = pArray;

	tex->tmu = GR_TMU0;
	tex->evenOdd= GR_MIPMAPLEVELMASK_BOTH;

	return true;
}

/********************************************/
/* DownloadTexture							*/
/* Download a texture from a JpegTexture	*/
/*	struct									*/
/********************************************/
void DownloadTexture(JpegTexture *tex)
{
	tex->start = g_StartTextMem;
	g_StartTextMem += tex->width * tex->height * 2;

	grTexDownloadMipMap(tex->tmu, tex->start, tex->evenOdd, &tex->info);

}

/********************************************/
/* FreeTexture								*/
/* Free a texture							*/
/********************************************/
void FreeTexture(JpegTexture *tex)
{
	g_StartTextMem -= tex->width * tex->height * 2;
}

/********************************************/
/* LoadJpeg2Array							*/
/* Allocate an array and load an JPEG into	*/
/********************************************/

WORD* LoadJpeg2Array(DWORD Filename, int* width, int* height)
{
	struct jpeg_decompress_struct cinfo;
	struct jpeg_error_mgr jerr;
	BYTE **buffer;
	DWORD size_img;
	WORD *outbuf;
	FILE* file;
	DWORD Cpt1;
	DWORD Dummy;

	jpeg_create_decompress(&cinfo);
	cinfo.err = jpeg_std_error(&jerr);

	file = fopen(PackageName, "rb");
	SeekToSubfile(file, Filename, &Dummy);

	jpeg_stdio_src(&cinfo, file);
	jpeg_read_header(&cinfo, TRUE);
	jpeg_start_decompress(&cinfo);

	if (width)
		*width = cinfo.image_width;
	if (height)
		*height = cinfo.image_height;

	outbuf = (WORD*)malloc(sizeof(WORD)* cinfo.image_height * cinfo.image_width);

	buffer = (BYTE**)malloc(sizeof(BYTE*)*cinfo.image_height);
	if (buffer==NULL){
		free(outbuf);
		fclose(file);
		return NULL;
	}
	buffer[0] = (BYTE*)malloc(sizeof(BYTE)*cinfo.image_height * cinfo.image_width * 3);
	if (buffer[0]==NULL)
		return NULL;
	for(Cpt1=0;Cpt1<cinfo.image_height;Cpt1++)
		buffer[Cpt1] = buffer[0] + Cpt1 * cinfo.image_width * 3;

//

	while (cinfo.output_scanline < cinfo.output_height)
		jpeg_read_scanlines(&cinfo, buffer+cinfo.output_scanline, cinfo.output_height);
	size_img = cinfo.image_height*cinfo.image_width;
	for(Cpt1=0;Cpt1<size_img;Cpt1++)
	{
		BYTE r,g,b;
		r = buffer[0][Cpt1*3] >> 3;
		g = buffer[0][Cpt1*3+1] >> 2;
		b = buffer[0][Cpt1*3+2] >> 3;
		*(outbuf+Cpt1) = b + (g<<5) + (r<<11);
	}

//
	jpeg_finish_decompress(&cinfo);
	jpeg_destroy_decompress(&cinfo);


	fclose(file);

	free(buffer[0]);
	free(buffer);
	return outbuf;
}

static BYTE *buffer[100];
static BYTE pixelbuf[256*100*3];


// Function name	: PrepareVideo
// Description	    : 
// Return type		: void 
void PrepareVideo()
{
	DWORD Cpt1;

	buffer[0] = &pixelbuf[0];
	for(Cpt1=0;Cpt1<100;Cpt1++)
		buffer[Cpt1] = buffer[0] + Cpt1 * 256;
}

/********************************************/
/* LoadJpeg2Array							*/
/* Allocate an array and load an JPEG into	*/
/********************************************/

void LoadJpeg2ArrayPrealloc(BYTE* outbuf, FILE* file, int* width, int* height)
{
	struct jpeg_decompress_struct cinfo;
	struct jpeg_error_mgr jerr;
	DWORD size_img;
	DWORD Cpt1;

	jpeg_create_decompress(&cinfo);
	cinfo.err = jpeg_std_error(&jerr);

	jpeg_stdio_src(&cinfo, file);
	jpeg_read_header(&cinfo, TRUE);
	jpeg_start_decompress(&cinfo);

	if (width)
		*width = cinfo.image_width;
	if (height)
	*height = cinfo.image_height;

//

	while (cinfo.output_scanline < cinfo.output_height)
		//jpeg_read_scanlines(&cinfo, buffer+cinfo.output_scanline, cinfo.output_height);
		jpeg_read_scanlines(&cinfo, buffer+cinfo.output_scanline, 100);
	size_img = cinfo.image_height*cinfo.image_width;
	for(Cpt1=0;Cpt1<size_img;Cpt1++)
	{
		*(outbuf+Cpt1) = buffer[0][Cpt1];
	}

//
	jpeg_finish_decompress(&cinfo);
	jpeg_destroy_decompress(&cinfo);

	//fclose(file);

	return;
}


/********************************************/
/* Move the texture pointer to the			*/
/* Beginning of the texture memory			*/
/********************************************/

void Init_Textures()
{
	g_StartTextMem = grTexMinAddress(GR_TMU0);
}